// utils/tool.js
import Day from './dayjs'

/**
 * 时间戳格式化
 * 1715072168340 => 2024-05-07 16:56:08
 * format=YYYY/MM/DD HH:mm:ss
 */
export const timeStampFormat = (timeStamp, opt) => {
    if (!timeStamp || timeStamp == -1 || timeStamp == '-1' || timeStamp == 0 || timeStamp == '0') {
        return ''
    }
    timeStamp = parseInt(String(timeStamp))
    const format = opt?.format || 'YYYY/MM/DD HH:mm:ss'
    return Day(timeStamp).format(format)
}

/**
 *接受一个对象并返回一个只包含非空和非 null 值的新对象
 */
export const filterEmptyValues = (obj) => {
    return Object.entries(obj)
        .filter(([_, value]) => value !== null && value !== undefined && value !== '')
        .reduce((acc, [key, value]) => {
            acc[key] = value
            return acc
        }, {})
}

/**
 *数组去重
 */
export const uniqueArray = (arr) => {
    let uniqueArr = []
    let obj = {}
    for (let i = 0; i < arr.length; i++) {
        let str = JSON.stringify(arr[i])
        if (!obj[str]) {
            uniqueArr.push(arr[i])
            obj[str] = true
        }
    }
    return uniqueArr
}
