import { ref } from 'vue'
import { allInBoundMode, currentInBoundModeForFlightSinglePage } from './currentInBoundMode'
import { disableUpdateInTimeForTasks } from './scheduledReload'

export const fromTablePartIdentifierProps = ref({
    depStn: '',
    stdChn: ''
})

export const timeRangeSpecifier = ref(0)

export const currentAllRelatedFlights = ref([])

export const currentFlightDataPassAlong = ref({})

export const isFetchingDataInFlightSingle = ref(false)

export const currentFlightSingleHandlingAc = ref('')

export const currentSelectedIndexInAllRelatedFlights = ref(0)

export const currentFlightSingleHandlingAcType = ref('')

export const currentAirlineCode = ref('')

let initialIndexConfig = 0
let initialType = allInBoundMode.In

export function setUpInitialSwitchConfig() {
    initialIndexConfig = currentSelectedIndexInAllRelatedFlights.value
    initialType = currentInBoundModeForFlightSinglePage.value
}

export function beforeJumpSingleFlightHandleFunc(ac, identifier, inBoundMode, airlineCode) {
    currentAllRelatedFlights.value = []
    currentFlightDataPassAlong.value = {}
    currentFlightSingleHandlingAc.value = ac
    fromTablePartIdentifierProps.value = identifier
    currentInBoundModeForFlightSinglePage.value = inBoundMode
    currentAirlineCode.value = airlineCode
}

export function currentSelectedIndexInAllRelatedFlightsChanged(v) {
    disableUpdateInTimeForTasks()
    currentSelectedIndexInAllRelatedFlights.value = v
    currentFlightDataPassAlong.value = currentAllRelatedFlights.value[v]
    if (v === initialIndexConfig) {
        currentInBoundModeForFlightSinglePage.value = initialType
    } else if (v === initialIndexConfig + 1) {
        currentInBoundModeForFlightSinglePage.value = initialType === allInBoundMode.In ? allInBoundMode.Out : allInBoundMode.In
    }
}


