import { defineStore } from 'pinia'
import Day from 'mocp/utils/dayjs'

const currentTime = Day(new Date())
const dateEnd = currentTime.format('YYYY-MM-DD')

const useFleetStore = defineStore('fleet', {
    state: () => {
        return {
            searchData: {
                aviation: '',
                machineNumber: '',
                model: '',
                ata: '',
                state: '1',
                startTime: '',
                stopTime: '',
                isTime: 2,
                isUpdateTime: 2,
                faultDescribe: '',
                dateEnd
            },
            detailsId: undefined
        }
    },
    getters: {},
    actions: {
        resetForm() {
            this.searchData = {
                aviation: '',
                machineNumber: '',
                model: '',
                ata: '',
                state: '1',
                startTime: '',
                stopTime: '',
                isTime: 2,
                isUpdateTime: 2,
                faultDescribe: '',
                dateEnd
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useFleetStore
