import { upload } from 'mocp/utils/http'
import { canvasImage } from './sign.compositions'
import { antiicingFile, antiicingFlag, deicingFile, deicingFlag, formData, showAntiicing, showDeicing } from './add.compositions'
import { addDeicingApi } from 'mocp/api/electronicBill'

export const handleSubmit = async () => {
    uni.showLoading({
        title: '保存中...',
        mask: true
    })
    try {
        await uploadFile()
        await addDeicing()
    } catch (error) {
        console.error(error)
    } finally {
        uni.hideLoading()
    }
}
export const uploadFile = async () => {
    const res = await upload({ url: '/resource/uploadFile', filePath: canvasImage.value, name: 'file' })
    if (res.code == 200) {
        formData.customerSignImg = res.data.fileUrl
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
export const addDeicing = async () => {
    const params = {
        ...formData
    }
    if (formData.deicingMix == 'Other') {
        params.deicingMix = formData.deicingMix1 + ':' + formData.deicingMix2
    }
    if (formData.antiicingMix == 'Other') {
        params.antiicingMix = formData.antiicingMix1 + ':' + formData.antiicingMix2
    }
    const res = await addDeicingApi(formData, { loading: true })
    if (res.code == 200) {
        uni.$mocpJump.navigateBack()
        resetData()
        uni.$mocpMessage.success(res.message)
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
export const resetData = () => {
    Object.assign(formData, {
        acreg: '',
        aircaraftoperator: '',
        antiicingCartNo1: '',
        antiicingCartNo2: '',
        antiicingCartNo3: '',
        antiicingCartNo4: '',
        antiicingDuration: '',
        antiicingEndTime: '',
        antiicingMix: '',
        antiicingMix1: undefined,
        antiicingMix2: undefined,
        antiicingPersion1: '',
        antiicingPersion2: '',
        antiicingPersion3: '',
        antiicingPersion4: '',
        antiicingQuantity1: undefined,
        antiicingQuantity2: undefined,
        antiicingQuantity3: undefined,
        antiicingQuantity4: undefined,
        antiicingQuantityTotal: undefined,
        antiicingStartTime: '',
        antiicingType: '',
        antiicingUnit1: '',
        antiicingUnit2: '',
        antiicingUnit3: '',
        antiicingUnit4: '',
        customerSignImg: '',
        date: '',
        deicingCartNo1: '',
        deicingCartNo2: '',
        deicingCartNo3: '',
        deicingCartNo4: '',
        deicingEndTime: '',
        deicingMix: '',
        deicingMix1: undefined,
        deicingMix2: undefined,
        deicingPersion1: '',
        deicingPersion2: '',
        deicingPersion3: '',
        deicingPersion4: '',
        deicingQuantity1: undefined,
        deicingQuantity2: undefined,
        deicingQuantity3: undefined,
        deicingQuantity4: undefined,
        deicingQuantityTotal: undefined,
        deicingStartTime: '',
        deicingType: '',
        deicingUnit1: '',
        deicingUnit2: '',
        deicingUnit3: '',
        deicingUnit4: '',
        expectDeicing: 0,
        fixedPointDeicing: 0,
        flightNoIn: '',
        flightNoOut: '',
        id: undefined,
        legs: '',
        model: '',
        nickname: '',
        originalAircraftPositionDeicing: 0,
        station: '',
        username: '',
        guaranteeUnit: '',
        weatherToday: '',
        modelType: '',
        remark: '',
        deicingFile: '',
        deicingRemark: '',
        antiicingFile: '',
        antiicingRemark: ''
    })
    showDeicing.value = false
    showAntiicing.value = false
    deicingFlag.value = false
    antiicingFlag.value = false
    deicingFile.value = []
    antiicingFile.value = []
}
