import { upload } from 'mocp/utils/http'
import { canvasImage } from './sign.compositions'
import { formData } from './add.compositions'
import { addNonRoutineWorkApi } from 'mocp/api/electronicBill'

export const handleSubmit = async () => {
    uni.showLoading({
        title: '保存中...',
        mask: true
    })
    try {
        await uploadFile()
        await addNonRoutineWork()
    } catch (error) {
        console.error(error)
    } finally {
        uni.hideLoading()
    }
}
export const uploadFile = async () => {
    const res = await upload({ url: '/resource/uploadFile', filePath: canvasImage.value, name: 'file' })
    if (res.code == 200) {
        formData.customerSignImg = res.data.fileUrl
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
export const addNonRoutineWork = async () => {
    const res = await addNonRoutineWorkApi(formData, { loading: true })
    if (res.code == 200) {
        uni.$mocpJump.navigateBack()
        Object.assign(formData, {
            acreg: '',
            acu: undefined,
            aircaraftoperator: '',
            asu: undefined,
            charger: undefined,
            cherryPicker: undefined,
            customerSignImg: '',
            date: '',
            flightNo: '',
            gpu: undefined,
            hanger: undefined,
            id: 0,
            jackscrew: undefined,
            ladder: undefined,
            legs: '',
            material1: '',
            material2: '',
            material3: '',
            model: '',
            nickname: '',
            number1: undefined,
            number2: undefined,
            number3: undefined,
            oxygenCharging: undefined,
            powerTool: undefined,
            shockStrutCharging: undefined,
            station: '',
            tails: undefined,
            tireCharging: undefined,
            tools: undefined,
            tractor: undefined,
            username: '',
            work1: '',
            work2: '',
            work3: '',
            workingHours1: undefined,
            workingHours2: undefined,
            workingHours3: undefined
        })
        uni.$mocpMessage.success(res.message)
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
