import { defineStore } from 'pinia'
import { getAllAcApi, getAllAcTypeApi, getAllAirlineApi } from 'mocp/api/electronicBill'

const useElectronicBillStore = defineStore('electronicBill', {
    state: () => {
        return {
            selectList: {
                allAc: [], //机号列表
                allAcType: [], //机型列表
                allAirline: [] //航司列表
            }
        }
    },
    getters: {},
    actions: {
        async init() {
            uni.showLoading({
                mask: true,
                title: '加载中...'
            })
            try {
                await Promise.all([this.getAllAc(), this.getAllAcType(), this.getAllAirline()])
            } catch (error) {
                console.log(error)
            } finally {
                uni.hideLoading()
            }
        },
        async getAllAc() {
            const res = await getAllAcApi({})
            if (res.code == 200) {
                this.selectList.allAc = res.data
            } else {
                uni.$mocpMessage.error(res.message)
            }
        },
        async getAllAcType() {
            const res = await getAllAcTypeApi({})
            if (res.code == 200) {
                this.selectList.allAcType = res.data
            } else {
                uni.$mocpMessage.error(res.message)
            }
        },
        async getAllAirline() {
            const res = await getAllAirlineApi({})
            if (res.code == 200) {
                this.selectList.allAirline = res.data
            } else {
                uni.$mocpMessage.error(res.message)
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useElectronicBillStore
