import useBaseStore from 'mocp/store/base'
import useUserStore from 'mocp/store/user'

/**
 * 操作权限校验
 * @param {Array} value 校验值
 * @returns {Boolean}
 */
export const checkPermi = (value) => {
    const userStore = useUserStore()
    if (value) {
        if (Array.isArray(value)) {
            return value.some((val) => userStore.getApiPaths.includes(val))
        } else {
            return userStore.getApiPaths.includes(value)
        }
    } else {
        return false
    }
}

/**
 * 获取配置数据并过滤列表
 * @param {String} permissionName 模块名
 * @param {Array} list 原始列表
 * @param {String} configKey 配置数据键名
 * @returns {Array}
 */
export const getFilteredList = (permissionName, list, configKey) => {
    const userStore = useUserStore()
    const configData = userStore.configData.find((item) => item.permissionName === permissionName)
    const commonConfig = userStore.getCommonConfigData[configKey] || ''
    let configValue = ''
    if (configData) {
        configValue = configData.soleSettings === '1' ? configData[configKey] || '' : `${commonConfig},${configData[configKey]}`
    }
    //去掉末尾逗号
    configValue = configValue.replace(/,$/, '')
    const filteredList = list.filter((item) => new Set(configValue.split(',')).has(item.value))
    return configValue ? filteredList : list
}

/**
 * 权限航司下拉框数据
 * @param {String} permissionName 模块名
 * @returns {Array}
 */
export const getAirlineSelect = (permissionName) => {
    const baseStore = useBaseStore()
    const list = baseStore.selectList.airlineCodeList.map((z) => ({
        value: z.zOP3,
        label: z.zOP3 + z.shortName
    }))
    return getFilteredList(permissionName, list, 'airline')
}

/**
 * 权限机型下拉框数据
 * @param {String} permissionName 模块名
 * @returns {Array}
 */
export const getTypeSelect = (permissionName) => {
    const baseStore = useBaseStore()
    const list = baseStore.selectList.typeList.map((a) => ({
        label: a,
        value: a
    }))
    return getFilteredList(permissionName, list, 'acType')
}

/**
 * 权限航站下拉框数据
 * @param {String} permissionName 模块名
 * @returns {Array}
 */
export const getTerminalSelect = (permissionName) => {
    const baseStore = useBaseStore()
    const list = baseStore.selectList.terminalList?.map((z) => ({
        value: z.terminalCode,
        label: z.terminalCity + '-' + z.terminalName + '-' + z.terminalCode
    }))
    return getFilteredList(permissionName, list, 'airport')
}
