import { getAirlineAcregApi } from 'mocp/api/electronicBill'
import { formData } from './add.compositions'

export const changeAcreg = async (acreg) => {
    if (!acreg) return
    const res = await getAirlineAcregApi({ acreg }, { loading: true })
    if (res.code == 200) {
        if (res.data?.aircaraftoperator) {
            formData.aircaraftoperator = res.data.aircaraftoperator
        }
        if (res.data?.actype) {
            formData.model = res.data.actype
        }
        if (res.data?.flightNo) {
            formData.flightNoIn = res.data.flightNo
        }
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
