import { upload } from 'mocp/utils/http'
import { canvasImage } from './sign.compositions'
import { formData } from './add.compositions'
import { addRoutineWorkApi } from 'mocp/api/electronicBill'

export const handleSubmit = async () => {
    uni.showLoading({
        title: '保存中...',
        mask: true
    })
    try {
        await uploadFile()
        await addRoutineWork()
    } catch (error) {
        console.error(error)
    } finally {
        uni.hideLoading()
    }
}
export const uploadFile = async () => {
    const res = await upload({ url: '/resource/uploadFile', filePath: canvasImage.value, name: 'file' })
    if (res.code == 200) {
        formData.customerSignImg = res.data.fileUrl
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
export const addRoutineWork = async () => {
    const res = await addRoutineWorkApi(formData, { loading: true })
    if (res.code == 200) {
        uni.$mocpJump.navigateBack()
        Object.assign(formData, {
            acreg: '',
            af: 0,
            airConditioning: undefined,
            airStarter: undefined,
            aircaraftoperator: '',
            customerSignImg: '',
            date: '',
            diversion: 0,
            flightNoIn: '',
            flightNoOut: '',
            groundPower: undefined,
            id: 0,
            legs: '',
            model: '',
            nickname: '',
            onCall: 0,
            others1: '',
            others2: '',
            pf: 0,
            remark: '',
            returnFlight: 0,
            serviceAf: 0,
            servicePf: 0,
            serviceTr: 0,
            station: '',
            towPus: undefined,
            tr: 1,
            username: ''
        })
        uni.$mocpMessage.success(res.message)
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
