import { http } from 'mocp/utils/http'

//获取用户基本信息分页列表
export const getAdminListApi = (data, config) => {
    return http({
        method: 'POST',
        url: '/system/getAdminList',
        data,
        config
    })
}

//获取用户基本信息详情
export const getAdminDetailApi = (data, config) => {
    return http({
        method: 'POST',
        url: '/system/getAdminDetail',
        data,
        config
    })
}

//通过机号查询飞机相关数据
export const getAcReduceListApi = (data, config) => {
    return http({
        method: 'POST',
        url: '/system/Aircraft/getAcReduceList',
        data,
        config
    })
}

//通过机号和航站查询相关席位
export const getSysSeatListApi = (data, config) => {
    return http({
        method: 'POST',
        url: '/system/getSysSeatList',
        data,
        config
    })
}

//获取某用户拥有的席位列表(不分页)
export const getUserSeatListApi = (data, config) => {
    return http({
        method: 'POST',
        url: '/system/getUserSeatList',
        data,
        config
    })
}

//获取操作权限
export const getSeatPermissionApi = (data, config) => {
    return http({
        method: 'POST',
        url: '/system/getSeatPermission',
        data,
        config
    })
}

//获取数据权限
export const getConfigDataApi = (data, config) => {
    return http({
        method: 'POST',
        url: '/system/sysSeatPermissionData/getConfigData',
        data,
        config
    })
}
