import { defineStore } from 'pinia'
import { menuList } from 'mocpStatic/js/menu'

const useUserStore = defineStore('mocpUser', {
    state: () => {
        return {
            token: '',
            userInfo: undefined, //用户信息
            allMenuItem: { id: 999, name: '全部菜单', icon: 'all', group: '', count: 0 },
            allUserList: [], //所有登录用户存储的信息
            //席位权限
            seatId: '', //当前席位id
            seatPermission: ['all'], //操作权限
            configData: [] //数据权限
        }
    },
    getters: {
        //获取操作权限相关
        getApiPaths(state) {
            if (state.seatPermission.includes('all')) {
                return ['all']
            } else {
                return state.seatPermission.map((item) => item.apiPath)
            }
        },
        //获取数据权限相关
        getCommonConfigData(state) {
            return state.configData.find((item) => item.permissionId == '0') || {}
        },
        //获取全部菜单
        getMenuList(state) {
            if (state.seatPermission.includes('all')) {
                return menuList.value
            }
            return menuList.value.filter((item) => state.getApiPaths.includes(item.apiPath) || !item.apiPath)
        },
        //获取分组菜单
        getGroupMenuList(state) {
            return state.getMenuList.reduce((groups, item) => {
                // 如果该组不存在，则创建一个新组
                if (!groups[item.group]) {
                    groups[item.group] = []
                }
                // 将当前项添加到对应的组中
                groups[item.group].push(item)
                return groups
            }, {})
        },
        //获取当前登录用户的首页菜单
        getHomeMenuList(state) {
            if (!state.userInfo) return []
            const homeMenuList = state.allUserList.find((item) => item.userId == state.userInfo.id)?.homeMenuList || []
            const ids = []
            homeMenuList.forEach((item) => {
                ids.push(item.id)
            })
            return state.getMenuList.filter((item) => ids.includes(item.id))
        }
    },
    actions: {
        //用户登录
        setUserInfo(data) {
            this.token = data.token
            this.userInfo = data
            //加入用户首页菜单信息
            if (!this.allUserList.find((item) => item.userId == this.userInfo.id)) {
                //记录菜单id
                this.allUserList.push({
                    userId: this.userInfo.id,
                    homeMenuList: this.getMenuList
                        .filter((item) => item.default)
                        .map((item) => {
                            return { id: item.id }
                        })
                })
            }
        },
        //退出登录
        handleLogOut() {
            this.resetUserInfo()
            //返回登录页面
            uni.$mocpJump.redirectTo('/login/index')
        },
        //重置用户信息
        resetUserInfo() {
            this.token = ''
            this.userInfo = undefined
            this.seatId = ''
            this.seatPermission = ['all']
            this.configData = []
        },
        //修改用户首页菜单
        changeHomeMenuList(menuList) {
            const index = this.allUserList.findIndex((item) => item.userId == this.userInfo.id)
            this.allUserList[index].homeMenuList = menuList.map((item) => {
                return { id: item.id }
            })
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: {
        // 调整为兼容多端的API
        storage: {
            setItem(key, value) {
                uni.setStorageSync(key, value)
            },
            getItem(key) {
                return uni.getStorageSync(key)
            }
        }
    }
})
export default useUserStore
