import { reactive } from 'vue'

export const formData = reactive({
    acreg: '',
    acu: undefined,
    aircaraftoperator: '',
    asu: undefined,
    bjjkzyxs: undefined,
    bjjkzyzk: undefined,
    bjscpxs: undefined,
    bjscpzk: undefined,
    cdydq: undefined,
    cgydq: undefined,
    charger: undefined,
    cherryPicker: undefined,
    cy: undefined,
    createTime: '',
    createUser: undefined,
    customerSignImg: '',
    customerSignTime: '',
    cyfdlgjcs: '',
    cyfdlgjjh: '',
    cydlgjcs: '',
    cydlgjjh: '',
    date: '',
    fbjjkzyxs: undefined,
    fbjjkzyzk: undefined,
    fbjscpxs: undefined,
    fbjscpzk: undefined,
    flightNo: '',
    flightNoIn: '',
    flightNoOut: '',
    gjcl: undefined,
    gpu: undefined,
    hanger: undefined,
    hlgj: undefined,
    hy: undefined,
    id: 0,
    isDel: '',
    jackscrew: undefined,
    jgrygs: undefined,
    jgrygsHuors: undefined,
    jsjd: undefined,
    jsqjd: undefined,
    ladder: undefined,
    legs: '',
    legs1: '',
    legs2: '',
    legs3: '',
    gkgzt: undefined,
    lzqjd: undefined,
    material1: '',
    material2: '',
    material3: '',
    model: '',
    ndtktsbjh: '',
    ndtktsbts: undefined,
    ndtrygs: undefined,
    nickname: '',
    number1: undefined,
    number2: undefined,
    number3: undefined,
    oxygenCharging: undefined,
    powerTool: undefined,
    ptgzt: undefined,
    qtgj: [],
    qtxhp: undefined,
    shockStrutCharging: undefined,
    sjcptcc: undefined,
    sjcptcr: undefined,
    station: '',
    tails: undefined,
    tireCharging: undefined,
    tjpxs: undefined,
    tjpzk: undefined,
    tools: undefined,
    tractor: undefined,
    ttfj: undefined,
    updateTime: '',
    updateUser: undefined,
    username: '',
    work1: '',
    work2: '',
    work3: '',
    workingHours1: undefined,
    workingHours2: undefined,
    workingHours3: undefined,
    xbgkcc: undefined,
    xbgkcr: undefined,
    yyy: undefined
})

export const rules = reactive({
    station: [
        {
            required: true,
            message: '请选择航站',
            trigger: ['blur', 'change']
        }
    ],
    date: [
        {
            type: 'number',
            required: true,
            message: '请选择日期',
            trigger: ['blur', 'change']
        }
    ],
    acreg: [
        {
            required: true,
            message: '请选择机号',
            trigger: ['blur', 'change']
        }
    ],
    aircaraftoperator: [
        {
            required: true,
            message: '请选择飞机所属单位',
            trigger: ['blur', 'change']
        }
    ],
    model: [
        {
            required: true,
            message: '请选择机型',
            trigger: ['blur', 'change']
        }
    ],
    flightNoIn: [
        {
            required: true,
            message: '请选择进港航班号',
            trigger: ['blur', 'change']
        },
        {
            validator: (rule, value, callback) => {
                return /^[A-Z0-9]{2}\d{1,4}[A-Z]?$/.test(value)
            },
            message: '进港航班号格式错误',
            trigger: ['blur', 'change']
        }
    ],
    flightNoOut: [
        {
            validator: (rule, value, callback) => {
                return value && /^[A-Z0-9]{2}\d{1,4}[A-Z]?$/.test(value)
            },
            message: '出港航班号格式错误',
            trigger: ['blur', 'change']
        }
    ]
})
