import { defineStore } from 'pinia'
import useUserStore from 'mocp/store/user'
import { getArrangeWorkListForAppApi, getDecisiongetDecisionToDoApi, getRqmListForMobileApi, getTechnicalEvaluationToDoApi } from 'mocp/api/my-toDo'
import { getPwdTaskListForMobileApi } from 'mocp/api/windDamageManagement'

const useMyToDoStore = defineStore('myToDo', {
    state: () => {
        return {
            assignWorkNum: 0, //布置工作
            appraisalRecordNum: 0, //考核记录
            moveDecisionNum: 0, //运行决策
            technologyEvaluationNum: 0, //技术评估
            windDamageManagementNum: 0 //防风害管理
        }
    },
    getters: {
        getTotal(state) {
            const total =
                state.assignWorkNum + state.appraisalRecordNum + state.moveDecisionNum + state.technologyEvaluationNum + state.windDamageManagementNum
            if (total > 0) {
                if (total > 99) {
                    return '99+'
                } else {
                    return total
                }
            } else {
                return '-'
            }
        },
        getAssignWorkNum(state) {
            if (state.assignWorkNum > 99) {
                return '99+'
            } else {
                return state.assignWorkNum
            }
        },
        getAppraisalRecordNum(state) {
            if (state.appraisalRecordNum > 99) {
                return '99+'
            } else {
                return state.appraisalRecordNum
            }
        },
        getMoveDecisionNum(state) {
            if (state.moveDecisionNum > 99) {
                return '99+'
            } else {
                return state.moveDecisionNum
            }
        },
        getTechnologyEvaluationNum(state) {
            if (state.technologyEvaluationNum > 99) {
                return '99+'
            } else {
                return state.technologyEvaluationNum
            }
        },
        getWindDamageManagementNum(state) {
            if (state.windDamageManagementNum > 99) {
                return '99+'
            } else {
                return state.windDamageManagementNum
            }
        }
    },
    actions: {
        async getArrangeWorkListForApp() {
            const userStore = useUserStore()
            const res = await getArrangeWorkListForAppApi({ pageIndex: 1, pageSize: 10, userId: userStore.userInfo?.id })
            if (res.code == 200) {
                this.assignWorkNum = parseInt(res.data.total) || 0
            }
        },
        async getRqmListForMobile() {
            const userStore = useUserStore()
            const res = await getRqmListForMobileApi({ pageIndex: 1, pageSize: 10, userId: userStore.userInfo?.id })
            if (res.code == 200) {
                this.appraisalRecordNum = parseInt(res.total) || 0
            }
        },
        async getDecisiongetDecisionToDo() {
            const res = await getDecisiongetDecisionToDoApi({ pageIndex: 1, pageSize: 10 })
            if (res.code == 200) {
                this.moveDecisionNum = parseInt(res.data.total) || 0
            }
        },
        async getTechnicalEvaluationToDo() {
            const res = await getTechnicalEvaluationToDoApi({ pageIndex: 1, pageSize: 10 })
            if (res.code == 200) {
                this.technologyEvaluationNum = parseInt(res.data.total) || 0
            }
        },
        async getPwdTaskListForMobile() {
            const userStore = useUserStore()
            const res = await getPwdTaskListForMobileApi({ userId: userStore.userInfo?.id })
            if (res.code == 200) {
                this.windDamageManagementNum = this.countWindDamageManagementNum(res.data)
            }
        },
        async initData() {
            await Promise.all([
                (this.getArrangeWorkListForApp(),
                this.getRqmListForMobile(),
                this.getDecisiongetDecisionToDo(),
                this.getTechnicalEvaluationToDo(),
                this.getPwdTaskListForMobile())
            ])
        },
        countWindDamageManagementNum(data) {
            let count = 0
            data.forEach((element) => {
                count = count + element?.basicInfoList.length
            })
            return count
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useMyToDoStore
