import { defineStore } from 'pinia'
import { ref } from 'vue'

//默认default最多显示15个,id唯一标识
const menuList = ref([
    // 生产保障
    { id: 'xxtb', name: '信息通报', icon: 'xxtb', group: '生产保障', default: true, count: 0, url: '/panel/inforDisclosure/search' },
    { id: 'hbbz', name: '航班保障', icon: 'hbbz', group: '生产保障', default: true, count: 0, url: '/panel/flight-support/list' },
    { id: 'AOG', name: 'AOG任务', icon: 'AOG', group: '生产保障', default: true, count: 0, url: '/panel/aog/search' },
    { id: 'wdgj', name: '我的跟机', icon: 'wdgj', group: '生产保障', default: true, count: 0, url: '/panel/supported-task/list' },
    { id: 'sfd', name: '收费单', icon: 'sfd', group: '生产保障', default: true, count: 0, url: '/panel/electronicBill/list' },
    // 维修控制
    { id: 'bzcsj', name: '不正常事件', icon: 'bzcsj', group: '维修控制', default: false, count: 0, url: '/panel/abnormalEventManage/list' },
    { id: 'yxdc', name: '运行调查', icon: 'yxdc', group: '维修控制', default: false, count: 0, url: '/panel/operationalSurvey/list' },
    { id: 'yxjc', name: '运行决策', icon: 'yxjc', group: '维修控制', default: false, count: 0, url: '/panel/move-decision/list' },
    { id: 'bzgz', name: '布置工作', icon: 'bzgz', group: '维修控制', default: false, count: 0, url: '/panel/assign-work/search' },
    { id: 'jxyw', name: '机械延误', icon: 'jxyw', group: '维修控制', default: false, count: 0, url: '/panel/mechanicalAbnormalEvents/list' },
    { id: 'ffh', name: '防风害', icon: 'ffh', group: '维修控制', default: false, count: 0, url: '/panel/windDamageManagement/list' },
    // 技术支援
    { id: 'jdzt', name: '机队状态', icon: 'jdzt', group: '技术支援', default: true, count: 0, url: '/panel/fleet/search' },
    { id: 'zysq', name: '支援申请', icon: 'zysq', group: '技术支援', default: false, count: 0, url: '/panel/support-application/search' },
    { id: 'gzzl', name: '工作指令', icon: 'gzzl', group: '技术支援', default: false, count: 0, url: '/panel/work-assignment/search' },
    { id: 'jspg', name: '技术评估', icon: 'jspg', group: '技术支援', default: false, count: 0, url: '/panel/technology-evaluation/list' },
    { id: 'jsfx', name: '技术分析', icon: 'jsfx', group: '技术支援', default: false, count: 0, url: '/panel/technicalAnalysis/list' },
    { id: 'MCO', name: 'MCO', icon: 'MCO', group: '技术支援', default: true, count: 0, url: '/panel/mco/search' },
    { id: 'wjll', name: '文件浏览', icon: 'wjll', group: '技术支援', default: false, count: 0, url: '/panel/fileList/index' },
    // 运行品质
    { id: 'pzfx', name: '品质分析', icon: 'pzfx', group: '运行品质', default: false, count: 0, url: '/panel/qualityAnalysis/list' },
    { id: 'khjl', name: '考核记录', icon: 'khjl', group: '运行品质', default: false, count: 0, url: '/panel/appraisal-record/list' },
    { id: 'gcfx', name: '工程分析', icon: 'gcfx', group: '运行品质', default: false, count: 0, url: '/panel/engineeringEvaluation/list' },
    // 航站管理
    { id: 'hzgl', name: '航站管理', icon: 'hzgl', group: '航站管理', default: false, count: 0 },
    { id: 'xydw', name: '协议单位', icon: 'xydw', group: '航站管理', default: false, count: 0, url: '/panel/workSupervision/list' }
])
const useUserStore = defineStore('mocpUser', {
    state: () => {
        return {
            token: '',
            userInfo: undefined, //用户信息
            allMenuItem: { id: 999, name: '全部菜单', icon: 'all', group: '', count: 0 },
            allUserList: [] //所有登录用户存储的信息
        }
    },
    getters: {
        //获取全部菜单
        getMenuList() {
            return menuList.value
        },
        //获取分组菜单
        getGroupMenuList(state) {
            return state.getMenuList.reduce((groups, item) => {
                // 如果该组不存在，则创建一个新组
                if (!groups[item.group]) {
                    groups[item.group] = []
                }
                // 将当前项添加到对应的组中
                groups[item.group].push(item)
                return groups
            }, {})
        },
        //获取当前登录用户的首页菜单
        getHomeMenuList(state) {
            const homeMenuList = state.allUserList.find((item) => item.userId == state.userInfo?.id)?.homeMenuList
            const ids = []
            homeMenuList.forEach((item) => {
                ids.push(item.id)
            })
            return state.getMenuList.filter((item) => ids.includes(item.id))
        }
    },
    actions: {
        //用户登录
        setUserInfo(data) {
            this.token = data.token
            this.userInfo = data
            //加入用户首页菜单信息
            if (!this.allUserList.find((item) => item.userId == this.userInfo.id)) {
                //记录菜单id
                this.allUserList.push({
                    userId: this.userInfo.id,
                    homeMenuList: this.getMenuList
                        .filter((item) => item.default)
                        .map((item) => {
                            return { id: item.id }
                        })
                })
            }
            //跳转工作台
            uni.$mocpJump.redirectTo('/tab/index')
        },
        //退出登录
        handleLogOut() {
            this.token = ''
            this.userInfo = undefined
            //返回登录页面
            uni.$mocpJump.redirectTo('/login/index')
        },
        //修改用户首页菜单
        changeHomeMenuList(menuList) {
            const index = this.allUserList.findIndex((item) => item.userId == this.userInfo.id)
            this.allUserList[index].homeMenuList = menuList.map((item) => {
                return { id: item.id }
            })
        }
    },
    // 配置持久化
    persist: {
        // 调整为兼容多端的API
        storage: {
            setItem(key, value) {
                uni.setStorageSync(key, value)
            },
            getItem(key) {
                return uni.getStorageSync(key)
            }
        }
    }
})
export default useUserStore
