import { getAirlineAcregApi } from 'mocp/api/electronicBill'
import { antiicingFile, antiicingFlag, deicingFile, deicingFlag, formData, formRef, showAntiicing, showDeicing } from './add.compositions'
import { validateParameters } from 'mocp/utils/tool'
import { showToast } from 'mocp/utils/message'

export const changeAcreg = async (acreg) => {
    if (!acreg) return
    const res = await getAirlineAcregApi({ acreg }, { loading: true })
    if (res.code == 200) {
        if (res.data?.aircaraftoperator) {
            formData.aircaraftoperator = res.data.aircaraftoperator
        }
        if (res.data?.actype) {
            formData.model = res.data.actype
        }
        if (res.data?.flightNo) {
            formData.flightNoIn = res.data.flightNo
            formData.flightNoOut = res.data.flightNo
        }
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
export const getDeicingFile = (value) => {
    deicingFile.value = value
}
export const getAntiicingFile = (value) => {
    antiicingFile.value = value
}
export const deicingValidate = () => {
    if (!formData.modelType) {
        return uni.$mocpMessage.warning('请选择机型类别')
    }
    if (!formData.weatherToday) {
        return uni.$mocpMessage.warning('请选择当日天气')
    }
    //验证除冰混合比(Other)
    if (formData.deicingMix == 'Other' && (!formData.deicingMix1 || !formData.deicingMix2)) {
        return uni.$mocpMessage.warning('请填写除冰自定义混合比')
    }
    //验证除冰记录完整性
    if (!validateParameters(formData.deicingCartNo1, formData.deicingPersion1, formData.deicingQuantity1, formData.deicingUnit1)) {
        return uni.$mocpMessage.warning('请完整填写第1条除冰记录')
    }
    if (!validateParameters(formData.deicingCartNo2, formData.deicingPersion2, formData.deicingQuantity2, formData.deicingUnit2)) {
        return uni.$mocpMessage.warning('请完整填写第2条除冰记录')
    }
    if (!validateParameters(formData.deicingCartNo3, formData.deicingPersion3, formData.deicingQuantity3, formData.deicingUnit3)) {
        return uni.$mocpMessage.warning('请完整填写第3条除冰记录')
    }
    if (!validateParameters(formData.deicingCartNo4, formData.deicingPersion4, formData.deicingQuantity4, formData.deicingUnit4)) {
        return uni.$mocpMessage.warning('请完整填写第4条除冰记录')
    }
    return true
}
export const antiicingValidate = () => {
    if (!formData.modelType) {
        return uni.$mocpMessage.warning('请选择机型类别')
    }
    if (!formData.weatherToday) {
        return uni.$mocpMessage.warning('请选择当日天气')
    }
    //验证防冰混合比(Other)
    if (formData.antiicingMix == 'Other' && (!formData.antiicingMix1 || !formData.antiicingMix2)) {
        return uni.$mocpMessage.warning('请填写防冰自定义混合比')
    }
    //验证防冰记录完整性
    if (!validateParameters(formData.antiicingCartNo1, formData.antiicingPersion1, formData.antiicingQuantity1, formData.antiicingUnit1)) {
        return uni.$mocpMessage.warning('请完整填写第1条防冰记录')
    }
    if (!validateParameters(formData.antiicingCartNo2, formData.antiicingPersion2, formData.antiicingQuantity2, formData.antiicingUnit2)) {
        return uni.$mocpMessage.warning('请完整填写第2条防冰记录')
    }
    if (!validateParameters(formData.antiicingCartNo3, formData.antiicingPersion3, formData.antiicingQuantity3, formData.antiicingUnit3)) {
        return uni.$mocpMessage.warning('请完整填写第3条防冰记录')
    }
    if (!validateParameters(formData.antiicingCartNo4, formData.antiicingPersion4, formData.antiicingQuantity4, formData.antiicingUnit4)) {
        return uni.$mocpMessage.warning('请完整填写第4条防冰记录')
    }
    return true
}
export const handleFooterClick = async () => {
    await formRef.value?.validate()
    if (!deicingValidate()) {
        return
    }
    if (!antiicingValidate()) {
        return
    }
    //是否点击提交验证除冰/防冰用量
    if (!deicingFlag.value && formData.deicingQuantityTotal > 0) {
        return uni.$mocpMessage.warning('请提交除冰记录')
    }
    if (!antiicingFlag.value && formData.antiicingQuantityTotal > 0) {
        return uni.$mocpMessage.warning('请提交防冰记录')
    }
    uni.$mocpJump.navigateTo('/panel/electronicBill/deicing/sign')
}
/**
 * 对应天气类别	霜/雾	小雪	中雪/冻雾	大雪/结冰
     窄体	 100-400 400-700   700-1000   1000-2000
    宽体	 300-700 700-1200  1200-2000   2000-4000
*/
export const getLimit = () => {
    if (formData.modelType == '1') {
        if (['1', '2'].includes(formData.weatherToday)) {
            return [300, 700]
        } else if (['5'].includes(formData.weatherToday)) {
            return [700, 1200]
        } else if (['3', '6'].includes(formData.weatherToday)) {
            return [1200, 2000]
        } else if (['4', '7'].includes(formData.weatherToday)) {
            return [2000, 4000]
        }
    } else {
        if (['1', '2'].includes(formData.weatherToday)) {
            return [100, 400]
        } else if (['5'].includes(formData.weatherToday)) {
            return [400, 700]
        } else if (['3', '6'].includes(formData.weatherToday)) {
            return [700, 1000]
        } else if (['4', '7'].includes(formData.weatherToday)) {
            return [1000, 2000]
        }
    }
    return [0, 999999999999999]
}
/**
 *
 * @param {*} a 用量
 * @param {*} b 单位
 */
export const getOneTotal = (a, b) => {
    let unit = 0
    if (b == 'L' || b == 'KG') {
        unit = 1
    }
    if (b == 'USG') {
        unit = 3.7854
    }
    return (a || 0) * unit
}
export const submitDeicing = () => {
    if (!deicingValidate()) {
        return
    }
    const limit = getLimit()
    if (formData.deicingQuantityTotal && formData.deicingQuantityTotal > 0) {
        if (formData.deicingQuantityTotal > limit[1]) {
            showDeicing.value = true
        } else {
            deicingFlag.value = true
            showToast('提交成功')
        }
    }
}
export const confirmDeicing = () => {
    if (!formData.deicingRemark) {
        return showToast('请填写超量使用原因')
    }
    if (!formData.deicingFile) {
        return showToast('至少上传一张图片')
    }
    showToast('提交成功')
    deicingFlag.value = true
    showDeicing.value = false
}
export const submitAntiicing = () => {
    if (!antiicingValidate()) {
        return
    }
    const limit = getLimit()
    if (formData.antiicingQuantityTotal && formData.antiicingQuantityTotal > 0) {
        if (formData.antiicingQuantityTotal > limit[1]) {
            showAntiicing.value = true
        } else {
            antiicingFlag.value = true
            showToast('提交成功')
        }
    }
}
export const confirmAntiicing = () => {
    if (!formData.antiicingRemark) {
        return showToast('请填写超量使用原因')
    }
    if (!formData.antiicingFile) {
        return showToast('至少上传一张图片')
    }
    showToast('提交成功')
    antiicingFlag.value = true
    showAntiicing.value = false
}
