import useBaseStore from 'mocp/store/base'

export const getParamsByType = (paramType) => {
    const baseStore = useBaseStore()
    return baseStore.allBasicParams[paramType]
        ?.filter((item) => item.isDel == 0)
        ?.map((item) => {
            return { label: item.paramName, value: item.paramCode }
        })
}

export const getParamNameByValue = (paramType, paramName, extend = {}) => {
    if (extend && extend.isArray) {
        const paramNameArray = paramName.split(',')
        return paramNameArray
            .reduce((q, w) => {
                if (getParamNameByValue(paramType, w)) {
                    q.push(getParamNameByValue(paramType, w))
                }
                return q
            }, [])
            .join(',')
    }
    return getParamsByType(paramType).find((item) => item.value == paramName)?.label || ''
}
