import { getMcoDetailsApi } from 'mocp/api/mco'
import { defineStore } from 'pinia'

const useMcoStore = defineStore('mco', {
    state: () => {
        return {
            searchData: {
                state: null,
                machineNumber: '',
                model: '',
                terminal: '',
                majorCategory: '',
                startTime: '',
                stopTime: '',
                faultDescription: '',
                testRun: null,
                airStop: null,
                inspect: null
            },
            id: '',
            details: undefined,
            materialsIndex: -1, //航材详情下标
            toolsIndex: -1, //工具详情下标
            stepIndex: -1 //步骤详情下标
        }
    },
    getters: {
        //航材列表
        getMaterialsList(state) {
            return state.details?.materialsList?.materialsList || []
        },
        getMaterialsDetails(state) {
            return this.getMaterialsList[state.materialsIndex]
        },
        //工具列表
        getToolsList(state) {
            return state.details?.toolsList?.materialsList || []
        },
        getToolsDetails(state) {
            return this.getToolsList[state.toolsIndex]
        },
        //步骤列表
        getStepList(state) {
            return state.details?.mcoStepList || []
        },
        getStepDetails(state) {
            return this.getStepList[state.stepIndex]
        }
    },
    actions: {
        resetForm() {
            this.searchData = {
                state: null,
                machineNumber: '',
                model: '',
                terminal: '',
                majorCategory: '',
                startTime: '',
                stopTime: '',
                faultDescription: '',
                testRun: null,
                airStop: null,
                inspect: null
            }
        },
        async getMcoDetails() {
            const res = await getMcoDetailsApi({ id: this.id }, { loading: true })
            if (res.code == 200) {
                this.details = res.data
            } else {
                uni.$mocpMessage.error(res.message)
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useMcoStore
