import { getRqmDetailsApi } from 'mocp/api/appraisal-record'
import { defineStore } from 'pinia'

const useAbnormalEventManageStore = defineStore('abnormalEventManage', {
    state: () => {
        return {
            searchData: {
                state: 0,
                terminalCode: '',
                repairUnit: '',
                aviation: '',
                occurrenceTimeStart: null,
                occurrenceTimeEnd: null,
                delay: undefined,
                category: '',
                pointsDeductionL: undefined,
                pointsDeductionH: undefined,
                eventProperty: '',
                handledBy: '',
                reviewedState: ''
            },
            details: undefined
        }
    },
    getters: {},
    actions: {
        async getRqmDetails() {
            const res = await getRqmDetailsApi({ id: this.id }, { loading: true })
            if (res.code == 200) {
                this.details = res.data
            } else {
                uni.$mocpMessage.error(res.message)
            }
        },
        resetForm() {
            this.searchData = {
                state: 0,
                terminalCode: '',
                repairUnit: '',
                aviation: '',
                occurrenceTimeStart: null,
                occurrenceTimeEnd: null,
                delay: undefined,
                category: '',
                pointsDeductionL: undefined,
                pointsDeductionH: undefined,
                eventProperty: '',
                handledBy: '',
                reviewedState: ''
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useAbnormalEventManageStore
