import { getPaData2Api } from 'mocp/api/engineeringEvaluation'
import { defineStore } from 'pinia'

const useEngineeringEvaluationStore = defineStore('engineeringEvaluation', {
    state: () => {
        return {
            searchData: {
                isOpen: 1,
                acTerminal: '',
                acOwn: '',
                acType: '',
                ac: '',
                majorClass: null,
                ataChapter: ''
            },
            workbenchId: '',
            details: undefined
        }
    },
    getters: {},
    actions: {
        async getPaData2() {
            const res = await getPaData2Api({ workbenchId: this.workbenchId }, { loading: true })
            if (res.code == 200) {
                this.details = res.data
            } else {
                uni.$mocpMessage.error(res.message)
            }
        },
        resetForm() {
            this.searchData = {
                isOpen: 1,
                acTerminal: '',
                acOwn: '',
                acType: '',
                ac: '',
                majorClass: null,
                ataChapter: ''
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useEngineeringEvaluationStore
