import { getAllTaskInfoByWeatherApi } from 'mocp/api/windDamageManagement'
import { defineStore } from 'pinia'

const useWindDamageManagementStore = defineStore('windDamageManagement', {
    state: () => {
        return {
            tabIndex: 0,
            searchData: {
                0: {
                    isOpen: 1,
                    rxStatus: '',
                    terminal: '',
                    proposedTimeBegin: null,
                    proposedTimeEnd: null
                },
                1: {
                    isOpen: 1,
                    rxStatus: '',
                    terminal: '',
                    proposedTimeBegin: null,
                    proposedTimeEnd: null
                },
                2: {
                    isOpen: 1,
                    rxStatus: '',
                    terminal: '',
                    proposedTimeBegin: null,
                    proposedTimeEnd: null
                },
                3: {
                    isOpen: 1,
                    rxStatus: '',
                    terminal: '',
                    proposedTimeBegin: null,
                    proposedTimeEnd: null
                }
            },
            weatherId: '',
            weatherSource: undefined,
            basicId: undefined,
            details: undefined
        }
    },
    getters: {
        getSearchData(state) {
            return state.searchData[state.tabIndex]
        },
        getDetails(state) {
            if (state.tabIndex == 0) {
                return state.details?.patrolList.find((item) => item.patrolBasicVo.id == String(state.basicId)) || {}
            } else if (state.tabIndex == 1) {
                return state.details?.operateList.find((item) => item.operateBasicVo.id == String(state.basicId)) || {}
            } else if (state.tabIndex == 2) {
                return state.details?.mooringList.find((item) => item.mooringBasicVo.id == String(state.basicId)) || {}
            } else if (state.tabIndex == 3) {
                return state.details?.sandstormList.find((item) => item.sandstormBasicVo.id == String(state.basicId)) || {}
            }
            return {}
        },
        getBasicVo(state) {
            if (state.tabIndex == 0) {
                return this.getDetails.patrolBasicVo || {}
            } else if (state.tabIndex == 1) {
                return this.getDetails?.operateBasicVo || {}
            } else if (state.tabIndex == 2) {
                return this.getDetails?.mooringBasicVo || {}
            } else if (state.tabIndex == 3) {
                return this.getDetails?.sandstormBasicVo || {}
            }
            return {}
        },
        getConclusionVo(state) {
            if (state.tabIndex == 0) {
                return this.getDetails.patrolConclusionVo || {}
            } else if (state.tabIndex == 1) {
                return this.getDetails.operateConclusionVo || {}
            } else if (state.tabIndex == 2) {
                return this.getDetails.mooringConclusionVo || {}
            } else if (state.tabIndex == 3) {
                return this.getDetails.sandstormConclusionVo || {}
            }
            return {}
        },
        getWorkVo(state) {
            if (state.tabIndex == 0) {
                return this.getDetails.patrolWorkVo || {}
            } else if (state.tabIndex == 1) {
                return this.getDetails.operateWorkVo || {}
            } else if (state.tabIndex == 2) {
                return this.getDetails.mooringWorkVo || {}
            } else if (state.tabIndex == 3) {
                return this.getDetails.sandstormWorkVo || {}
            }
            return {}
        },
        getDisabled(state) {
            if (state.tabIndex == 0) {
                return this.getBasicVo.rxStatus == '0' || state.details?.patrolIsOpen == '0'
            } else if (state.tabIndex == 1) {
                return this.getBasicVo.rxStatus == '0' || state.details?.operateIsOpen == '0'
            } else if (state.tabIndex == 2) {
                return this.getBasicVo.rxStatus == '0' || state.details?.mooringIsOpen == '0'
            } else if (state.tabIndex == 3) {
                return this.getBasicVo.rxStatus == '0' || state.details?.sandstormIsOpen == '0'
            }
            return false
        }
    },
    actions: {
        async getAllTaskInfoByWeather() {
            const res = await getAllTaskInfoByWeatherApi({ weatherId: this.weatherId, weatherSource: this.weatherSource }, { loading: true })
            if (res.code == 200) {
                this.details = res.data
            } else {
                uni.$mocpMessage.error(res.message)
            }
        },
        resetForm() {
            this.searchData[this.tabIndex] = {
                isOpen: 1,
                rxStatus: '',
                terminal: '',
                proposedTimeBegin: null,
                proposedTimeEnd: null
            }
        },
        setSearchData(searchData) {
            this.searchData[this.tabIndex] = searchData
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useWindDamageManagementStore
