import { ref } from 'vue'

export const allInBoundMode = {
    In: 0,
    Out: 1
}

export const currentInBoundModeForFlightTablePage = ref(allInBoundMode.In)

export const currentInBoundModeForFlightSinglePage = ref(allInBoundMode.In)

export function decideReleaseStatus(v) {
    let allReleases = v.releases
    let manualReleases = allReleases.filter(a => a.isUserAdd)
    if (currentInBoundModeForFlightTablePage.value === allInBoundMode.Out) {
        manualReleases = manualReleases.filter(a => a.isOut)
        allReleases = allReleases.filter(a => a.isOut)
    } else {
        manualReleases = manualReleases.filter(a => !a.isOut)
        allReleases = allReleases.filter(a => !a.isOut)
    }
    if (manualReleases.length) {
        if (manualReleases.every(a => a.releaseStatus > 0)) {
            return {
                data: '已放行',
                color: 'color-blue'
            }
        }
        return {
            data: '未放行',
            color: 'color-red'
        }
    }
    if (allReleases.every(a => a.releaseStatus > 0)) {
        return {
            data: '已放行',
            color: 'color-blue'
        }
    }
    return {
        data: '未放行',
        color: 'color-red'
    }
}