import { getRqmDetailsApi, getRqmOptionsApi } from 'mocp/api/appraisal-record'
import { defineStore } from 'pinia'

const useAppraisalRecordStore = defineStore('appraisalRecord', {
    state: () => {
        return {
            searchData: {
                status: 1,
                valid: null,
                department: '',
                appraisee: '',
                ac: null,
                acOwn: '',
                acType: '',
                startTime: null,
                stopTime: null,
                eventType: null,
                examineType: '',
                appealInfo: null
            },
            selectList: {
                appraisee: [],
                department: [],
                examineType: []
            },
            id: '',
            details: undefined
        }
    },
    getters: {
        getFileList(state) {
            return JSON.parse(state.details?.file) || []
        }
    },
    actions: {
        async getRqmOptions() {
            const res = await getRqmOptionsApi({})
            if (res.code == 200) {
                this.selectList.appraisee = res.data.appraisee || []
                this.selectList.department = res.data.department || []
                this.selectList.examineType = res.data.examineType || []
            }
        },
        async getRqmDetails() {
            const res = await getRqmDetailsApi({ id: this.id }, { loading: true })
            if (res.code == 200) {
                this.details = res.data
            } else {
                uni.$mocpMessage.error(res.message)
            }
        },
        resetForm() {
            this.searchData = {
                status: 1,
                valid: null,
                department: '',
                appraisee: '',
                ac: null,
                acOwn: '',
                acType: '',
                startTime: null,
                stopTime: null,
                eventType: null,
                examineType: '',
                appealInfo: null
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useAppraisalRecordStore
