import { getMcoDetailsApi } from 'mocp/api/mco'
import { defineStore } from 'pinia'

const useMcoStore = defineStore('mco', {
    state: () => {
        return {
            searchData: {
                state: null,
                machineNumber: '',
                model: '',
                terminal: '',
                majorCategory: '',
                startTime: '',
                stopTime: '',
                faultDescription: '',
                testRun: null,
                airStop: null,
                inspect: null
            },
            id: '',
            details: undefined,
            stepIndex: -1, //步骤详情下标
            feedBackType: 1 //反馈类型 1整体反馈  2额外反馈
        }
    },
    getters: {
        //航材列表
        getMaterialsList(state) {
            return state.details?.materialsList?.materialsList || []
        },
        //工具列表
        getToolsList(state) {
            return state.details?.toolsList?.materialsList || []
        },
        //步骤列表
        getStepList(state) {
            return state.details?.mcoStepList || []
        },
        getStepDetails(state) {
            return this.getStepList[state.stepIndex]
        },
        getStepBackDetails() {
            return this.getStepDetails?.backList || {}
        },
        //获取反馈详情
        getFeedBackDetails(state) {
            if (state.feedBackType == 1) {
                return state.details?.whole || {}
            } else {
                return state.details?.extra || {}
            }
        }
    },
    actions: {
        resetForm() {
            this.searchData = {
                state: null,
                machineNumber: '',
                model: '',
                terminal: '',
                majorCategory: '',
                startTime: '',
                stopTime: '',
                faultDescription: '',
                testRun: null,
                airStop: null,
                inspect: null
            }
        },
        async getMcoDetails() {
            const res = await getMcoDetailsApi({ id: this.id }, { loading: true })
            if (res.code == 200) {
                this.details = res.data
            } else {
                uni.$mocpMessage.error(res.message)
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useMcoStore
