import { reactive, ref } from 'vue'

export const formRef = ref()
//验证
export const rules = reactive({
    machineNumber: [
        {
            required: true,
            message: '请选择机号',
            trigger: ['blur', 'change']
        }
    ],
    terminal: [
        {
            required: true,
            message: '请选择航站',
            trigger: ['blur', 'change']
        }
    ],
    ata: [
        {
            required: true,
            message: '请选择ATA章节',
            trigger: ['blur', 'change']
        }
    ],
    specialty: [
        {
            required: true,
            message: '请选择专业',
            trigger: ['blur', 'change']
        }
    ],
    supportNeeds: [
        {
            required: true,
            message: '请输入支援需求',
            trigger: ['blur']
        }
    ],
    relevantSeats: [
        {
            required: true,
            message: '请选择相关席位',
            trigger: ['blur', 'change']
        }
    ]
})
// 表单数据
export const formData = reactive({
    id: '',
    machineNumber: null,
    model: null,
    aviation: null,
    terminal: null,
    ata: null,
    specialty: null,
    engineModel: null,
    supportNeeds: '',
    supportFile: '',
    faultDescription: '',
    airplaneState: '',
    manualDescription: '',
    suggestion: '',
    relevantSeats: null
})
//席位
export const relatedSeatSet = ref([])
