import { reactive, ref } from 'vue'

export const formRef = ref()
//验证
export const rules = reactive({
    packageNo: [
        {
            required: true,
            message: '请输入工作包编号',
            trigger: ['blur', 'change']
        }
    ],
    warningReason: [
        {
            required: true,
            message: '请输入申请原因',
            trigger: ['blur', 'change']
        }
    ],
    reason: [
        {
            required: true,
            message: '请输入具体原因',
            trigger: ['blur', 'change']
        }
    ],
    delayDay: [
        {
            required: true,
            type: 'number',
            message: '请输入延期天数',
            trigger: ['blur', 'change']
        }
    ],
    approver: [
        {
            required: true,
            message: '请选择审核人',
            trigger: ['blur']
        }
    ]
})
// 表单数据
export const materialPns = ref([''])
export const formData = reactive({
    packageNo: '',
    delayDay: '',
    approver: '',
    warningReason: '',
    materialDelay: '0',
    materialPns: '',
    reason: '',
    delayDay: null
})
