import { IModuleConf, SlateElement } from '@wangeditor/editor'
import { nodeSet } from '@/configs/node.config'

const elemToHtml = (type: string) => {
    return (elem: SlateElement, childrenHtml: string): string => {
        const dataKey = (elem as any).dataKey || ''
        return `<${type}
        data-w-e-type="${type}"
        data-key="${dataKey}"
    >${childrenHtml}</${type}>`
    }
}
const createElemConfig = (types: string | string[]) => {
    const configs: IModuleConf['elemsToHtml'] = []
    const typeArray = Array.isArray(types) ? types : [types]
    typeArray.forEach((type) => {
        configs.push({
            type,
            elemToHtml: elemToHtml(type)
        })
    })
    return configs
}

export default createElemConfig(nodeSet)
