import { h, VNode } from 'snabbdom'
import { IDomEditor, IModuleConf, SlateElement } from '@wangeditor/editor'
import { nodeSet } from '@/configs/node.config'

const renderElem = (type: string, style = { display: 'block' }) => {
    return (elem: SlateElement, children: VNode[] | null, editor: IDomEditor): VNode => {
        const dataKey = (elem as any).dataKey
        Object.assign(style, {
            // @ts-ignore
            textIndent: Number(elem.dataIndent) * 5 + 'px'
        })
        return h(type, { style, attrs: { 'data-key': dataKey } }, children)
    }
}
const createRenderConfig = (types: string | string[]) => {
    const configs: IModuleConf['renderElems'] = []
    const typeArray = Array.isArray(types) ? types : [types]
    typeArray.forEach((type) => {
        configs.push({
            type,
            renderElem: renderElem(type)
        })
    })
    return configs
}

export default createRenderConfig(nodeSet)
