import { NewTreeModification, OldTreeModification, TreeRenderResult } from '@/lib/XMLProcessor/src/typing'
import { compareLeftRef, compareRightRef } from '../constants/compare'

export const handleScrollTopLeft = (event: Event) => {
    const scrollTop = (event.target as HTMLInputElement).scrollTop
    compareRightRef.value?.handleScrollTop(scrollTop)
}
export const handleScrollTopRight = (event: Event) => {
    const scrollTop = (event.target as HTMLInputElement).scrollTop
    compareLeftRef.value?.handleScrollTop(scrollTop)
}
export const handleLeftDifferent = (dataForOld: OldTreeModification, treeNew: TreeRenderResult[]) => {
    nextTick(() => {
        const containerLeft = compareLeftRef.value?.editorRef.getEditableContainer()
        const containerRight = compareRightRef.value?.editorRef.getEditableContainer()
        //新增
        dataForOld.Deleted.map((item) => {
            const node = containerLeft!.querySelector(`[data-key="${item.key}"]`)
            if (node.childNodes.length == 1 && node.childNodes[0].nodeName == 'SPAN') {
                //处理左边
                node.classList.add('bg-errorColorSuppl')
                //处理右边
                const parentPath = item.chained.slice(0, item.chained.length - 1)
                const index = item.chained[item.chained.length - 1]
                const parentData = findNodeByChained(treeNew, parentPath)
                const parentNode = containerRight!.querySelector(`[data-key="${parentData?.key}"]`)
                // 创建一个新节点
                const newDiv = document.createElement('div')
                newDiv.style.height = `${node.offsetHeight}px`
                newDiv.classList.add('bg-dividerColor')
                parentNode && parentNode.insertBefore(newDiv, parentNode.childNodes[index])
            }
        })
        //修改
        dataForOld.Changed.map((item) => {
            const node = containerLeft!.querySelector(`[data-key="${item.key}"]`)
            if (node.childNodes.length == 1 && node.childNodes[0].nodeName == 'SPAN') {
                node.classList.add('bg-warningColorSuppl')
            }
        })
    })
}
export const handleRightDifferent = (dataForNew: NewTreeModification, treeOld: TreeRenderResult[]) => {
    nextTick(() => {
        const containerLeft = compareLeftRef.value?.editorRef.getEditableContainer()
        const containerRight = compareRightRef.value?.editorRef.getEditableContainer()
        //新增
        dataForNew.Added.map((item: any) => {
            const node = containerRight!.querySelector(`[data-key="${item.key}"]`)
            if (node.childNodes.length == 1 && node.childNodes[0].nodeName == 'SPAN') {
                //处理右边
                node.classList.add('bg-errorColorSuppl')
                //处理左边
                const parentPath = item.chained.slice(0, item.chained.length - 1)
                const index = item.chained[item.chained.length - 1]
                const parentData = findNodeByChained(treeOld, parentPath)
                const parentNode = containerLeft!.querySelector(`[data-key="${parentData?.key}"]`)
                // 创建一个新节点
                const newDiv = document.createElement('div')
                newDiv.style.height = `${node.offsetHeight}px`
                newDiv.classList.add('bg-dividerColor')
                parentNode && parentNode.insertBefore(newDiv, parentNode.childNodes[index])
            }
        })
        //修改
        dataForNew.Changed.map((item: any) => {
            const node = containerRight!.querySelector(`[data-key="${item.key}"]`)
            if (node.childNodes.length == 1 && node.childNodes[0].nodeName == 'SPAN') {
                node.classList.add('bg-warningColorSuppl')
            }
        })
    })
}

export const findNodeByChained = (data: TreeRenderResult[], targetChained: number[]): TreeRenderResult | null => {
    const dfs = (currentNode: TreeRenderResult): TreeRenderResult | null => {
        if (Array.isArray(currentNode.chained) && currentNode.chained.length === targetChained.length) {
            const isMatch = currentNode.chained.every((value, index) => value === targetChained[index])
            if (isMatch) {
                return currentNode // 找到目标节点
            }
        }
        if (currentNode.children && currentNode.children.length > 0) {
            for (const child of currentNode.children) {
                const result = dfs(child)
                if (result !== null) {
                    return result
                }
            }
        }
        return null // 当前节点及其子节点中没有找到目标节点
    }
    if (!Array.isArray(data) || data.length === 0) {
        return null // 数据无效
    }
    for (const node of data) {
        const result = dfs(node)
        if (result !== null) {
            return result
        }
    }
    return null // 没有找到目标节点
}
