// @ts-nocheck
import type { TreeOption } from 'naive-ui'
import { TreeRenderResult } from '@/lib/XMLProcessor/src/typing'

// 菜单相关
export const searchKey = ref('')
export const treeData: Ref<TreeOption[]> = ref([])
export const xmlDOM :Ref<Document>= ref()
export const treeSelectedKeys = ref<string[]>([])
export const xmlContent: Ref<string> = ref('')
//编辑器相关
export const editorRef = ref()
export const formData = reactive({
    html: ''
})
// 递归函数：检查树中是否存在满足条件的节点
// 递归函数：检查树中是否存在满足条件的节点，并构建新的树结构
function buildFilteredTree(
    tree: TreeRenderResult,
    searchString: string
): TreeRenderResult | null {
    // 如果当前节点的 label 包含指定字符串，直接返回当前节点
    if (tree.label.includes(searchString)) {
        return { ...tree }; // 返回当前节点的副本
    }

    // 如果当前节点有子节点，递归检查每个子节点
    if (tree.children) {
        const filteredChildren: TreeRenderResult[] = [];
        for (let child of tree.children) {
            const result = buildFilteredTree(child, searchString);
            if (result) {
                filteredChildren.push(result); // 如果子节点符合条件，加入到当前节点的子节点列表
            }
        }

        // 如果有符合条件的子节点，返回当前节点，并更新子节点列表
        if (filteredChildren.length > 0) {
            return { ...tree, children: filteredChildren };
        }
    }

    // 如果当前节点及其子节点都不满足条件，返回 null
    return null;
}

export const realComposableData = computed(function() {
    if (!searchKey.value) {
        return treeData.value
    }
    // @ts-ignore
    const result = buildFilteredTree(treeData.value[0], searchKey.value)
    if (!result) {
        return []
    }
    // @ts-ignore
    return [result]
})
