import { IButtonMenu, IDomEditor } from '@wangeditor/editor'
import { uploadXml } from '.'

class XMLMenu implements IButtonMenu {
    title: string
    tag: string
    constructor() {
        this.title = '上传XML' // 自定义菜单标题
        this.tag = 'button' // 菜单的标签，默认是button
    }
    getValue(editor: IDomEditor): string | boolean {
        // 获取菜单执行时的 value，用不到则返回空字符串或 false
        return ''
    }
    isActive(editor: IDomEditor): boolean {
        // 菜单是否需要激活，用不到则返回 false
        return false
    }
    isDisabled(editor: IDomEditor): boolean {
        // 菜单是否需要禁用，用不到则返回 false
        return false
    }
    async exec(editor: IDomEditor, value: string | boolean) {
        // 点击菜单时触发的函数
        if (this.isDisabled(editor)) return
        const arrFileHandle = await (window as any).showOpenFilePicker({
            types: [
                {
                    accept: {
                        'XML/*': ['.xml']
                    }
                }
            ]
        })
        const file = await arrFileHandle[0].getFile()
        uploadXml(file)
    }
}
export default {
    key: 'XML', // 定义 menu key，要保证唯一、不重复
    factory() {
        return new XMLMenu() // 返回定义的菜单类实例
    }
}
