import { IDomEditor, IModuleConf, SlateDescendant, SlateElement } from '@wangeditor/editor'
import { nodeSet } from '@/configs/node.config'

const parseElemHtml = (type: string) => {
    return (domElem: Element, children: SlateDescendant[], editor: IDomEditor): SlateElement => {
        const dataKey = domElem.getAttribute('data-key') || ''
        const dataIndent = domElem.getAttribute('data-indent-level') || ''
        const myResume = {
            type,
            dataKey,
            children,
            dataIndent
        }
        return myResume
    }
}
const createParseConfig = (types: string | string[]) => {
    const configs: IModuleConf['parseElemsHtml'] = []
    const typeArray = Array.isArray(types) ? types : [types]
    typeArray.forEach((type) => {
        configs.push({
            selector: `${type}[data-w-e-type="${type}"]`,
            parseElemHtml: parseElemHtml(type)
        })
    })
    return configs
}

export default createParseConfig(nodeSet)
