import { TreeRenderResult } from '@/lib/XMLProcessor/src/typing'
import { setEditorActive } from '.'
import { editorRef } from '../constants'
import { TreeOption } from 'naive-ui'

//点击节点
export const nodeProps = ({ option }: { option: TreeOption }) => {
    return {
        onClick() {
            setEditorActive(option.key as string, (id: string) => {
                editorRef.value?.scrollToElem(id)
            })
        }
    }
}
// 递归函数：检查树中是否存在满足条件的节点，并构建新的树结构
export const buildFilteredTree = (tree: TreeRenderResult, searchString: string): TreeRenderResult | null => {
    // 如果当前节点的 label 包含指定字符串，直接返回当前节点
    if (tree.label.includes(searchString)) {
        return { ...tree } // 返回当前节点的副本
    }
    // 如果当前节点有子节点，递归检查每个子节点
    if (tree.children) {
        const filteredChildren: TreeRenderResult[] = []
        for (let child of tree.children) {
            const result = buildFilteredTree(child, searchString)
            if (result) {
                filteredChildren.push(result) // 如果子节点符合条件，加入到当前节点的子节点列表
            }
        }
        // 如果有符合条件的子节点，返回当前节点，并更新子节点列表
        if (filteredChildren.length > 0) {
            return { ...tree, children: filteredChildren }
        }
    }
    // 如果当前节点及其子节点都不满足条件，返回 null
    return null
}

export const getAllKeys = (item: TreeOption[]) => {
    return item.reduce(function (q, w) {
        q.push(w.key as string)
        if (w.children) {
            q.push(...getAllKeys(w.children))
        }
        return q
    }, [] as string[])
}
