import mitt, { Emitter, EventType } from 'mitt'
import { onBeforeUnmount } from 'vue'

interface Fn {
    (...args: any[]): void
}
interface Option {
    name: string // 事件名称
    callback: Fn // 回调
}
const emitter: Emitter<Record<EventType, any>> = mitt()
export const useEventBus = (option?: Option) => {
    if (option) {
        const { name, callback } = option
        // 注册事件监听器
        emitter.on(name, callback)
        // 组件卸载时注销事件监听器
        onBeforeUnmount(() => {
            emitter.off(name, callback)
        })
    }
    // 返回事件总线的方法
    return {
        on: emitter.on.bind(emitter),
        off: emitter.off.bind(emitter),
        emit: emitter.emit.bind(emitter),
        all: emitter.all
    }
}
