import {TreeRenderResult} from '@/lib/XMLProcessor/src/typing'
import {UUID} from 'uuidjs'

export class Processing {
    private domParser: DOMParser

    constructor() {
        this.domParser = new DOMParser()
    }

    processXML(xmlContent: string, handledNode: string[]):{
        treeData: TreeRenderResult[], xmlDOM: Document
    } {
        const parsedTree = this.domParser.parseFromString(xmlContent, 'text/xml')
        let rootElement = parsedTree.documentElement
        return {
            treeData: this.innerHandle(rootElement, handledNode),
            xmlDOM: parsedTree
        }
    }

    private innerHandle(domNode: Element, handledNode: string[]): TreeRenderResult[] {
        let treeData: TreeRenderResult[] = [];
        // 必须添加根节点内容
        let targetKey = UUID.generate()
        let treeItem: TreeRenderResult = {
            key: targetKey,
            label: domNode.nodeName,
            children: [],
            index: 0,
            chained: [0]
        }
        domNode.setAttribute('data-key', targetKey);
        treeItem.children = this.innerGroupHandle(domNode.children, handledNode, [0])
        treeData.push(treeItem)

        return treeData
    }

    private innerGroupHandle(nodeSet: HTMLCollection, handledNode: string[], startChained: number[]) {
        let targetResult: TreeRenderResult[] = []
        let realIndex = -1;
        for (let i = 0; i < nodeSet.length; i++) {
            const node = nodeSet[i] as Element;
            if (!handledNode.includes(node.nodeName)) {
                if (node.children.length) {
                    targetResult.push(...this.innerGroupHandle(node.children, handledNode,startChained))
                }
                continue
            }
            realIndex++;
            let targetKey = UUID.generate()
            let treeItem: TreeRenderResult = {
                key: targetKey,
                label: node.nodeName,
                index: realIndex,
                chained: [...startChained, realIndex]
            }
            if (treeItem.label === 'CEP') {
                console.log('the res here', treeItem)
            }
            node.setAttribute('data-key', targetKey);
            if (node.children.length > 0) {
                treeItem.children = this.innerGroupHandle(node.children, handledNode, [...startChained, realIndex])
            }
            targetResult.push(treeItem)
        }
        return targetResult
    }
}