import { defineStore } from 'pinia'
import { AppState } from './types'
import { darkTheme } from 'naive-ui'
import { darkThemeConfig, lightThemeConfig } from '@/configs/tailwind.ui.config'

const useAppStore = defineStore('app', {
    state: (): AppState => {
        return {
            theme: null
        }
    },
    getters: {},
    actions: {
        changeTheme() {
            if (this.theme) {
                this.theme = null
            } else {
                this.theme = darkTheme
            }
            this.setTheme()
        },
        setTheme(themeData = lightThemeConfig) {
            if (this.theme) {
                themeData = darkThemeConfig
            }
            for (const [key, value] of Object.entries(themeData)) {
                // 将键转换为 CSS 变量格式
                const cssVarName = `--${key.replace(/([A-Z])/g, '-$1').toLowerCase()}`
                document.body.style.setProperty(cssVarName, value as string)
            }
            document.body.style.setProperty('--w-e-textarea-bg-color', themeData.baseColor)
            document.body.style.setProperty('--w-e-toolbar-bg-color', themeData.baseColor)
            document.body.style.setProperty('--w-e-textarea-color', themeData.textColorBase)
            document.body.style.setProperty('--w-e-toolbar-border-color', themeData.borderColor)
        }
    },
    persist: false
})

export default useAppStore
