import { h, VNode } from 'snabbdom'
import { IDomEditor, IModuleConf, SlateElement } from '@wangeditor/editor'
import { nodeSet } from '@/configs/node.config'
import { handleClickDom } from '@/views/editor/functions/compare'

const renderElem = (type: string, style = { display: 'block' }) => {
    return (elem: SlateElement, children: VNode[] | null, editor: IDomEditor): VNode => {
        const dataKey = (elem as any).dataKey
        const modifyType = (elem as any).modifyType
        Object.assign(style, {
            // @ts-ignore
            paddingLeft: Number(elem.dataIndent) * 10 + 'px'
        })
        return h(
            type,
            {
                style,
                attrs: { 'data-key': dataKey, 'data-modify-type': modifyType },
                on: {
                    click(event: Event) {
                        handleClickDom(event)
                    }
                }
            },
            children
        )
    }
}
const createRenderConfig = (types: string | string[]) => {
    const configs: IModuleConf['renderElems'] = []
    const typeArray = Array.isArray(types) ? types : [types]
    typeArray.forEach((type) => {
        configs.push({
            type,
            renderElem: renderElem(type)
        })
    })
    return configs
}

export default createRenderConfig(nodeSet)
