function createNodeFormDataItem(current: any, d: Document, contentHoldNode: string[]) {
    let rootNode = d.createElement(current.label);
    rootNode.setAttribute('data-key', current.key);
    rootNode.setAttribute('data-indent-level', current.chained.length.toString());
    rootNode.setAttribute('data-w-e-type', current.label);
    if (current.type) {
        rootNode.setAttribute('data-modify-type', current.type);
    }
    if (contentHoldNode.includes(current.label)) {
        rootNode.textContent = current.textContent;
    }
    return rootNode
}

export function reconstructTree(data: any[], contentHoldNode: string[]) {
    const d = new Document();
    let rootNode: any = null;
    const nodeMap = new Map<string, any>();
    for (let i = 0; i < data.length; i++) {
        const current = data[i];
        if (!rootNode) {
            rootNode = createNodeFormDataItem(current, d, contentHoldNode)
            nodeMap.set(current.key, rootNode)
            d.appendChild(rootNode);
        } else {
            const previousNode = data[i - 1];
            // 截取至当前节点的结合
            const nodeSetUntilNow = data.slice(0, i + 1);
            if (previousNode.chained.length < current.chained.length) {
                // 把上一个节点视为parent即可
                const parentNode = nodeMap.get(previousNode.key)!;
                const currentNode = createNodeFormDataItem(current, d, contentHoldNode);
                parentNode.appendChild(currentNode);
                nodeMap.set(current.key, currentNode);
            } else {
                // 找到离自己最近的上层节点
                const parentItem = nodeSetUntilNow.findLast((node) => {
                    return node.chained.length === current.chained.length - 1;
                })!;
                const parentNode = nodeMap.get(parentItem.key)!;
                const currentNode = createNodeFormDataItem(current, d, contentHoldNode);
                parentNode.appendChild(currentNode);
                nodeMap.set(current.key, currentNode);
            }
        }
    }
    return new XMLSerializer().serializeToString(d)
}