export type TreeRenderResult = {
    key: string,
    label: string,
    children?: TreeRenderResult[],
    hash: string,
    index: number,
    chained: number[],
    textContent: string,
    node: Element
}

export type TreeRenderResultFlatted = {
    key: string,
    label: string,
    hash: string,
    index: number,
    chained: number[],
    textContent: string,
    node: Element
}

export type TreeReconstructed = TreeRenderResultFlatted & {
    type: 'added' | 'removed' | null | 'placeholder'
}

export type OldTreeModification = {
    Deleted: TreeRenderResultFlatted[]
}

export type NewTreeModification = {
    Added: TreeRenderResultFlatted[],
}