import { ArrowLeft24Filled, ArrowRight24Filled, Book20Filled, TableInsertColumn24Filled } from '@vicons/fluent'
import { IDomEditor } from '@wangeditor/editor'

export const showLoading = ref(false)
//编辑器相关配置
export const editorRef = shallowRef<IDomEditor>()
export const editorHtml = ref('')
//菜单配置
export const toolbarConfig = {
    toolbarKeys: [
        'headerSelect',
        'bold',
        'italic',
        'underline',
        'through',
        'color',
        'fontSize',
        'lineHeight',
        'bulletedList',
        'numberedList',
        'justifyLeft',
        'justifyCenter',
        'justifyRight',
        'undo',
        'redo',
        'uploadImage',
        'insertLink',
        'fullScreen',
        'clearStyle'
    ]
}
//右键菜单
export const dropdownConfig = reactive({
    show: false,
    x: 0,
    y: 0,
    options: [
        {
            label: '左缩进',
            key: 'left',
            icon() {
                return h(NIcon, null, {
                    default: () => h(ArrowLeft24Filled)
                })
            }
        },
        {
            label: '右缩进',
            key: 'right',
            icon() {
                return h(NIcon, null, {
                    default: () => h(ArrowRight24Filled)
                })
            }
        },
        {
            label: '插入',
            key: 'insert',
            icon() {
                return h(NIcon, null, {
                    default: () => h(TableInsertColumn24Filled)
                })
            },
            children: [
                {
                    label: 'TaskTitle',
                    key: 'TaskTitle',
                    icon() {
                        return h(NIcon, null, {
                            default: () => h(Book20Filled)
                        })
                    }
                },
                {
                    label: 'TopicTitle',
                    key: 'TopicTitle',
                    icon() {
                        return h(NIcon, null, {
                            default: () => h(Book20Filled)
                        })
                    }
                }
            ]
        }
    ]
})
