import { chooseRowRef, compareContainerRef, compareLeftRef, compareRightRef, showCompare } from '../constants/compare'

export const handleClickDom = (event: any) => {
    if (!showCompare.value) return
    const element = event.target
    const container = compareContainerRef.value
    const elementRect = element.getBoundingClientRect()
    const containerRect = container.getBoundingClientRect()
    const distance = elementRect.top - containerRect.top
    chooseRowRef.value.style.top = distance + 'px'
    chooseRowRef.value.style.height = event.target.offsetHeight + 'px'
}
export const handleScrollTopLeft = (event: Event) => {
    const scrollTop = (event.target as HTMLInputElement).scrollTop
    compareRightRef.value?.handleScrollTop(scrollTop)
    chooseRowRef.value.style.height = '0px'
}
export const handleScrollTopRight = (event: Event) => {
    const scrollTop = (event.target as HTMLInputElement).scrollTop
    compareLeftRef.value?.handleScrollTop(scrollTop)
    chooseRowRef.value.style.height = '0px'
}
