import { showLoading } from '../constants'
import { IDomEditor } from '@wangeditor/editor'
import { treeData, treeRef, treeSelectedKeys } from '../constants/tree'
import { dropdownConfig, editorRef, editorHtml } from '../constants'
import { getUUID } from '@/utils'
import { compareData, showCompare } from '../constants/compare'
import TextA from '@/assets/file/CES-QEC-V250-A.xml?raw'
import TextB from '@/assets/file/Trans-Convert.xml?raw'
import { nodeSet, contentHoldNode } from '@/configs/node.config'
import { handleLeftDifferent, handleRightDifferent } from './compare'

export const handleCreated = (editor: IDomEditor) => {
    editorRef.value = editor
    handleChange(editor)
}
export const handleClick = (event: any) => {
    const key = getKey(event.target)
    treeRef.value?.scrollTo({ key })
    treeSelectedKeys.value = [key]
    setEditorActive(key)
}

let lastFocusedId = ''
export const setEditorActive = (key: string, callBack?: Function) => {
    const container = editorRef.value?.getEditableContainer()
    const id = container!.querySelector(`[data-key="${key}"]`)?.getAttribute('id') as string
    if (container) {
        if (lastFocusedId) {
            container.querySelector(`#${lastFocusedId}`)?.classList.remove('bg-primaryColorHover')
        }
        lastFocusedId = id
        container.querySelector(`#${id}`)?.classList.add('bg-primaryColorHover')
    }
    if (callBack) callBack(id)
}

//获取节点的key
export const getKey = (elem: any): string => {
    if (!elem) return ''
    const key = elem?.getAttribute('data-key')
    if (key) {
        return key
    } else {
        elem = elem.parentElement
        return getKey(elem)
    }
}
// 右键
export const handleContextMenu = (event: MouseEvent) => {
    dropdownConfig.show = false
    nextTick(() => {
        dropdownConfig.show = true
        dropdownConfig.x = event.clientX
        dropdownConfig.y = event.clientY
    })
}
// 右键选择
export const handleSelect = (key: string | number) => {
    dropdownConfig.show = false
    editorRef.value?.restoreSelection()
    if (key == 'TaskTitle') {
        const node = { type: 'TaskTitle', dataKey: getUUID(), children: [{ text: 'TaskTitle' }] }
        editorRef.value?.insertNode(node)
    } else if (key == 'TopicTitle') {
        const node = { type: 'TopicTitle', dataKey: getUUID(), children: [{ text: 'TopicTitle' }] }
        editorRef.value?.insertNode(node)
    }
}
export const onClickoutside = () => {
    dropdownConfig.show = false
}
// 编辑器内容变化
export const handleChange = (editor: IDomEditor) => {
    if (editor.getHtml() == '<p><br></p>') return
    const xmlProcessing = useXMLProcessing()
    const res = xmlProcessing.processXML(editor.getHtml().replace(/<p><br><\/p>/g, ''), nodeSet, contentHoldNode)
    treeData.value = res.treeData
}
// 上传xml
export const uploadXml = async () => {
    const input = document.createElement('input')
    input.type = 'file'
    input.accept = 'application/xml,text/xml'
    input.multiple = false
    input.click()
    input.addEventListener('change', async (event: Event) => {
        const files = (event.target as HTMLInputElement).files
        if (files && files.length > 0) {
            const file = files[0]
            const xmlProcessing = useXMLProcessing()
            showLoading.value = true
            const res = await xmlProcessing.processFile(file, nodeSet, contentHoldNode)
            showLoading.value = false
            editorHtml.value = res.xmlContent
        }
        input.remove()
    })
}
//xml对比
export const compareXml = () => {
    showCompare.value = true
    const xmlProcessing = useXMLProcessing()
    const res = xmlProcessing.dualCompareFromString(TextA, TextB, nodeSet, contentHoldNode)
    console.log(res)
    Object.assign(compareData, res)
    //比较数据
    // handleLeftDifferent()
    // handleRightDifferent()
}
