import vue from '@vitejs/plugin-vue'
import AutoImport from 'unplugin-auto-import/vite'
import { NaiveUiResolver } from 'unplugin-vue-components/resolvers'
import Components from 'unplugin-vue-components/vite'
import { resolve } from 'node:path'
import { defineConfig } from 'vite'

// https://vitejs.dev/config/
export default defineConfig({
    css: {
        preprocessorOptions: {
            less: {
                javascriptEnabled: true
            }
        }
    },
    plugins: [
        vue(),
        AutoImport({
            imports: [
                'vue',
                'vue-router',
                {
                    'naive-ui': ['useDialog', 'useMessage', 'useNotification', 'useLoadingBar'],
                    '@/hooks/useEventBus': ['useEventBus'],
                    '@/lib/XMLProcessor/src/index': ['useXMLProcessing']
                }
            ],
            dts: 'src/auto-import.d.ts',
            resolvers: [NaiveUiResolver()]
        }),
        Components({
            // 自动导入的组件位置，默认是src/components
            dirs: ['src/components'],
            resolvers: [NaiveUiResolver()]
        })
    ],
    resolve: {
        alias: {
            '@': resolve('src')
        }
    },
    base: './', // 打包路径
    server: {
        open: true, // 自动打开
        cors: true, // 跨域
        host: true,
        headers: {
            'Access-Control-Allow-Origin': '*',
        }
    }
})
