import { createRouter, createWebHashHistory, RouteRecordRaw } from 'vue-router'

const routes: Array<RouteRecordRaw> = [
    {
        path: '/',
        component: () => import(/* webpackChunkName: "Layout" */ '@/views/layout/index.vue'),
        name: 'Layout',
        redirect: '/editor',
        children: [
            {
                path: '/404',
                name: 'Error404',
                component: () => import(/* webpackChunkName: "Error404" */ '@/views/error/index.vue'),
                meta: { title: '404' }
            },
            {
                path: '/:pathMatch(.*)*',
                component: () => import(/* webpackChunkName: "Error404" */ '@/views/error/index.vue'),
                meta: { title: '404' }
            },
            {
                path: '/theme',
                component: () => import(/* webpackChunkName: "Theme" */ '@/views/example/theme.vue'),
                name: 'Theme',
                meta: { title: '主题' },
                children: []
            },
            {
                path: '/editor',
                name: 'Editor',
                component: () => import(/* webpackChunkName: "Editor" */ '@/views/editor/index.vue'),
                meta: { title: '在线编辑器' }
            }
        ]
    },
    {
        path: '/login',
        component: () => import(/* webpackChunkName: "Login" */ '@/views/login/index.vue'),
        name: 'Login',
        meta: { title: '登录' },
        children: []
    }
]

const router = createRouter({
    history: createWebHashHistory(),
    routes,
    // 切换路由跳转到顶部
    scrollBehavior() {
        return {
            left: 0,
            top: 0
        }
    }
})

export default router
