import { SlateElement, IModuleConf } from '@wangeditor/editor'

const elemToHtml = (type: string) => {
    return (elem: SlateElement, childrenHtml: string): string => {
        const dataKey = (elem as any).dataKey || ''
        return `<${type}
        data-w-e-type="${type}"
        data-key="${dataKey}"
    >${childrenHtml}</${type}>`
    }
}
const createElemConfig = (types: string | string[]) => {
    const configs: IModuleConf['elemsToHtml'] = []
    const typeArray = Array.isArray(types) ? types : [types]
    typeArray.forEach((type) => {
        configs.push({
            type,
            elemToHtml: elemToHtml(type)
        })
    })
    return configs
}
export default createElemConfig([
    'EOTK-HEADER',
    'JOBCARD',
    'CEP',
    'TITLE',
    'WARNING',
    'TFMATR',
    'PRETOPIC',
    'PARA',
    'LIST1',
    'L1ITEM',
    'TABLE',
    'TOPIC',
    'SUBTASK',
    'NOTE',
    'LIST2',
    'L2ITEM',
    'LIST3',
    'L3ITEM',
    'LIST4',
    'L4ITEM',
    'STEP',
    'RECORD-LINE'
])
