import { IDomEditor, SlateDescendant, SlateElement, IModuleConf } from '@wangeditor/editor'

const parseElemHtml = (type: string) => {
    return (domElem: Element, children: SlateDescendant[], editor: IDomEditor): SlateElement => {
        const dataKey = domElem.getAttribute('data-key') || ''
        const myResume = {
            type,
            dataKey,
            children
        }
        return myResume
    }
}
const createParseConfig = (types: string | string[]) => {
    const configs: IModuleConf['parseElemsHtml'] = []
    const typeArray = Array.isArray(types) ? types : [types]
    typeArray.forEach((type) => {
        configs.push({
            selector: `${type}[data-w-e-type="${type}"]`,
            parseElemHtml: parseElemHtml(type)
        })
    })
    return configs
}

export default createParseConfig([
    'EOTK-HEADER',
    'JOBCARD',
    'CEP',
    'TITLE',
    'WARNING',
    'TFMATR',
    'PRETOPIC',
    'PARA',
    'LIST1',
    'L1ITEM',
    'TABLE',
    'TOPIC',
    'SUBTASK',
    'NOTE',
    'LIST2',
    'L2ITEM',
    'LIST3',
    'L3ITEM',
    'LIST4',
    'L4ITEM',
    'STEP',
    'RECORD-LINE'
])
