import { h, VNode } from 'snabbdom'
import { IDomEditor, IModuleConf, SlateElement } from '@wangeditor/editor'

const renderElem = (type: string, style = { display: 'block' }) => {
    return (elem: SlateElement, children: VNode[] | null, editor: IDomEditor): VNode => {
        const dataKey = (elem as any).dataKey
        return h(type, { style, attrs: { dataKey: dataKey, id: dataKey } }, children)
    }
}
const createRenderConfig = (types: string | string[]) => {
    const configs: IModuleConf['renderElems'] = []
    const typeArray = Array.isArray(types) ? types : [types]
    typeArray.forEach((type) => {
        configs.push({
            type,
            renderElem: renderElem(type)
        })
    })
    return configs
}
export default createRenderConfig([
    'EOTK-HEADER',
    'JOBCARD',
    'CEP',
    'TITLE',
    'WARNING',
    'TFMATR',
    'PRETOPIC',
    'PARA',
    'LIST1',
    'L1ITEM',
    'TABLE',
    'TOPIC',
    'SUBTASK',
    'NOTE',
    'LIST2',
    'L2ITEM',
    'LIST3',
    'L3ITEM',
    'LIST4',
    'L4ITEM',
    'STEP',
    'RECORD-LINE'
])
