import { IDomEditor } from '@wangeditor/editor'
import { editorRef, formData, showLoading, treeData, treeRef, treeSelectedKeys, xmlContent, xmlDOM } from '../constants'
import { TreeOption } from 'naive-ui'
import { nodeSet } from '../constants/nodeParsed'
import { UUID } from 'uuidjs'

export const handleEditor = (editor: IDomEditor) => {
    if (editor.getHtml() == '<p><br></p>') return
    const xmlProcessing = useXMLProcessing()
    const res = xmlProcessing.processXML(editor.getHtml().replace(/<p><br><\/p>/g, ''), nodeSet)
    treeData.value = res.treeData
}

export const handleClick = (key: string) => {
    treeRef.value?.scrollTo({ key })
    treeSelectedKeys.value = [key]
    setEditorActive(key)
}

export const handleContextSelect = (key: string) => {
    if (key == 'TaskTitle') {
        const node = { type: 'TaskTitle', dataKey: 'g-' + UUID.generate(), children: [{ text: 'TaskTitle' }] }
        editorRef.value?.editorRef?.insertNode(node)
    } else if (key == 'TopicTitle') {
        const node = { type: 'TopicTitle', dataKey: 'g-' + UUID.generate(), children: [{ text: 'TopicTitle' }] }
        editorRef.value?.editorRef?.insertNode(node)
    }
}

export const nodeProps = ({ option }: { option: TreeOption }) => {
    return {
        onClick() {
            setEditorActive(option.key as string, (id: string) => {
                editorRef.value?.editorRef.scrollToElem([id])
            })
        }
    }
}

let lastFocusedId = ''
export const setEditorActive = (key: string, callBack?: Function) => {
    const container = editorRef.value?.editorRef.getEditableContainer()
    const id = container.querySelector(`[data-key="${key}"]`)?.getAttribute('id')
    if (container) {
        if (lastFocusedId) {
            container.querySelector(`#${lastFocusedId}`)?.classList.remove('bg-primaryColorHover')
        }
        lastFocusedId = id
        container.querySelector(`#${id}`)?.classList.add('bg-primaryColorHover')
    }
    if (callBack) callBack(id)
}

export const uploadXml = async () => {
    const input = document.createElement('input')
    input.type = 'file'
    input.accept = 'application/xml,text/xml'
    input.multiple = false
    input.click()
    input.addEventListener('change', async (event: Event) => {
        const files = (event.target as HTMLInputElement).files
        if (files && files.length > 0) {
            const file = files[0]
            const xmlProcessing = useXMLProcessing()
            showLoading.value = true
            const res = await xmlProcessing.processFile(file, nodeSet)
            showLoading.value = false
            formData.html = res.xmlContent
        }
    })
}
