import {ref} from "vue";

export const geoContainer = ref({
    width: 0, height: 0, designGraphWidth: 1920, designGraphHeight: 1080,
    contentWidth: 0, contentHeight: 0, paddingAll: 0
})

export function mapWidth(designWidth: number) {
    return geoContainer.value.width / geoContainer.value.designGraphWidth * designWidth
}

export function mapWidthStyle(designWidth: number, cssName: string) {
    return {
        [cssName]: mapWidth(designWidth)
    }
}

export function mapHeight(designHeight: number) {
    return geoContainer.value.height / geoContainer.value.designGraphHeight * designHeight
}

export function mapHeightStyle(designHeight: number, cssName: string) {
    return {
        [cssName]: mapHeight(designHeight)
    }
}