import {ScreenChartProps, SingleLayoutConf} from "../types/ScreenChart.typing.ts";
import {geoContainer, mapHeight, mapWidth} from "./mapGEOStyle.ts";

export const gridItemStyle = function (item: SingleLayoutConf, props: ScreenChartProps, geoConf: { rows: number, cols: number}) {
    return {
        position: 'absolute',
        background: '#f1f1f1',
        boxSizing: 'border-box',
        // @ts-ignore
        padding: `${mapHeight(props.gridItemPadding)}px ${mapWidth(props.gridItemPadding)}px ${mapHeight(props.gridItemPadding)}px ${mapWidth(props.gridItemPadding)}px`,
        fontSize: `${mapWidth(14)}px`,
        ...wholeGridGeo(item, geoConf, props.gap!),
        transition: 'left 0.3s ease, top 0.3 ease, width 0.3 ease, height 0.3 ease',
    }
}

export const wholeGridGeo = function (item: SingleLayoutConf, geoConf: { rows: number, cols: number}, gap: number) {
    const {rows, cols} = geoConf
    const cellWidth = (geoContainer.value.contentWidth - (cols - 1) * gap) / cols
    const cellHeight = (geoContainer.value.contentHeight - (rows - 1) * gap) / rows
    const left = item.x * (cellWidth + gap) + geoContainer.value.paddingAll;
    const top = item.y * (cellHeight + gap) + geoContainer.value.paddingAll;
    const width = item.w * cellWidth + (item.w - 1) * gap;
    const height = item.h * cellHeight + (item.h - 1) * gap;

    return {
        left: `${left}px`,
        top: `${top}px`,
        width: `${width}px`,
        height: `${height}px`,
    };
}

export function getAllGridSize(items: Array<SingleLayoutConf>) {
    let maxCol = 0;
    let maxRow = 0;

    for (const item of items) {
        // 计算当前元素的右边界和下边界
        const rightEdge = item.x + item.w;
        const bottomEdge = item.y + item.h;

        // 更新最大列数和行数
        if (rightEdge > maxCol) {
            maxCol = rightEdge;
        }
        if (bottomEdge > maxRow) {
            maxRow = bottomEdge;
        }
    }

    return { rows: maxRow, cols: maxCol };
}

export const mapContainerStyle = function (props: ScreenChartProps) {
    return {
        display: 'grid',
        boxSizing: 'border-box',
        // @ts-ignore
        padding: `${mapHeight(props.containerPadding)}px ${mapWidth(props.containerPadding)}px ${mapHeight(props.containerPadding)}px ${mapWidth(props.containerPadding)}px`,
    }
}