import {BarChartOptions, GeneralChartOptions, PieCharOptions} from "../types/ScreenChart.typing.ts";
import {ChartCompType} from "../const/chartCompType.ts";

export function mapToEchartsOptions(item: GeneralChartOptions) {
    if (item.type === ChartCompType.EChartsBar) {
        let series: any[]
        // 简单类型数据
        item = <BarChartOptions>item;
        if (item.data.every(a=>typeof a === 'number')) {
            series = [{data: item.data, type:'bar'}]
        } else {
            series = item.data.map((a) => {
                return {
                    type: 'bar',
                    name: a.name,
                    data: a.data
                }
            })
        }
        return {
            tooltip: {
                trigger: 'axis',
                axisPointer: {
                    type: 'shadow'
                }
            },
            grid: {
                left: '3%',
                right: '4%',
                bottom: '3%',
                containLabel: true,
                top: '5%'
            },
            xAxis: {
                type: 'category',
                data: item.category,
            },
            yAxis: {
                type: 'value',
                boundaryGap: [0, 0.01]
            },
            series
        }
    }
    if (item.type === ChartCompType.EChartsPie) {
        item = <PieCharOptions>item;
        const total = item.data.reduce((a, b) => a + b.value, 0);
        return {
            legend: {
                top: '5%',
                left: 'center'
            },
            radius: item.radius,
            type: 'pie',
            center: ['50%', '50%'],
            avoidLabelOverlap: false,
            emphasis: {
                scaleSize: 3,
            },
            label: {
                show: false,
            },
            labelLine: {
                show: false,
            },
            data: item.data.map(function (item) {
                return {
                    value: item.value,
                    name: item.name,
                    itemStyle: {
                        color: item.color
                    }
                }
            }),
            toolbox: false,
            tooltip: {
                trigger: "item",
                formatter: function (param: any) {
                    return `${param.name}：${
                        total ? ((param.value * 100) / total).toFixed(2) : 100
                    }% ${param.value}`;
                },
                showDelay: 0,
                hideDelay: 0,
                extraCssText: "pointer-events: none;",
                position: "top",
                appendTo: "body",
            },
        }
    }
}